#!/bin/bash

export ANDROID_NDK=/home/pechanove/android/android-ndk-r10b
export ANDROID_SDK=/home/pechanove/android/android-sdk-linux

NONE=`tput sgr0`
EMK=`tput bold`

write()
{
        echo "${EMK}$1${NONE}"
}

write "Cleaning FreeRDP..."
rm -rf FreeRDP
write "Done."

if [ -e FreeRDP.tar.gz ]
then
	write "Unpacking existent FreeRDP.tar.gz..."
	tar zxf FreeRDP.tar.gz
	write "Done."
else
	write "Downloading FreeRDP from git..."
	git clone https://github.com/FreeRDP/FreeRDP.git
	write "Done."

	write "Preparing build environment..."
	cd FreeRDP
	./scripts/android_setup_build_env.sh
	cd ..
	write "Done."

	write "Packing FreeRDP..."
	tar zcf FreeRDP.tar.gz FreeRDP
	write "Done."
fi

write "Overwriting icons..."
AFREERDP=FreeRDP/client/Android
cp ../logos/librework-clean.png $AFREERDP/aFreeRDP/assets/FreeRDP_Logo.png
cp ../logos/librework-32.png $AFREERDP/aFreeRDP/res/drawable-ldpi/icon_launcher_freerdp.png
cp ../logos/librework-48.png $AFREERDP/aFreeRDP/res/drawable-mdpi/icon_launcher_freerdp.png
cp ../logos/librework-72.png $AFREERDP/aFreeRDP/res/drawable-hdpi/icon_launcher_freerdp.png
cp ../logos/librework-96.png $AFREERDP/aFreeRDP/res/drawable/icon_launcher_freerdp.png
write "Done."

write "Patching code..."
sed -i -e "s/\tresolution = AUTOMATIC;/\tresolution = FITSCREEN;/g" FreeRDP/client/Android/FreeRDPCore/src/com/freerdp/freerdpcore/domain/BookmarkBase.java
write "Done."

cd FreeRDP

write "Overwriting application name..."
for i in `grep -r -w "aFreeRDP" * | grep -v "add_subdirectory(aFreeRDP)" | awk -F ':' '{print $1}' | sort -u`
do
	sed -i -e "s/aFreeRDP/Librework Client/g" $i
done
write "Done."

write "Doing cmake..."
cmake	-DCMAKE_TOOLCHAIN_FILE=cmake/AndroidToolchain.cmake \
	-DANDROID_NDK="{ANDROID_NDK}" \
	-DANDROID_SDK="${ANDROID_SDK}" \
	-DCMAKE_BUILD_TYPE=Debug \
	-DPKG_CONFIG_EXECUTABLE=/usr/bin/pkg-config \
	.
write "Done."

write "Building..."
make
write "Done."

cd ..
