#include "editserver.h"
#include "ui_editserver.h"

EditServer::EditServer(QWidget *parent, ClientSettings * settings, QString name) :
    QDialog(parent),
    ui(new Ui::EditServer)
{
    this->settings = settings;
    this->name = name;
    ui->setupUi(this);
    ui->advanced->setVisible(FREE_VERSION == 0);
    ui->advancedWidget->setVisible(ui->advanced->isChecked() && FREE_VERSION == 0);
    QStringList serverTypes = settings->serverTypes();
    for (int i = 0; i < serverTypes.count(); i++)
    {
        if (serverTypes[i] == "Librework")
        {
            ui->connType->addItem(QIcon(":/librework-logo-144.png"), serverTypes[i]);
        } else {
            ui->connType->addItem(QIcon(":/rdp.png"), serverTypes[i]);
        }
    }
    if (name == FREE_NAME || name == PREMIUM_NAME)
    {
        ui->connType->setEnabled(false);
        ui->connName->setEnabled(false);
        ui->server->setEnabled(false);
        ui->connPort->setEnabled(false);
    }
	ui->buttonBox->button(QDialogButtonBox::Ok)->setText(tr("OK"));
	ui->buttonBox->button(QDialogButtonBox::Cancel)->setText(tr("Cancel"));
    ui->screenSize->addItems(settings->screenSizes());
    ui->colorDepth->addItems(settings->colorDepths());
    isNew = name.isNull();

    if ( ! isNew )
    {
        loadSettings();
    }
#ifdef Q_OS_WIN
	ui->redirectHome->setVisible(false);
	ui->redirectHomeLabel->setVisible(false);
#endif
    /*for (int i = 'F'; i <= 'Z'; i++)
    {
        ui->redirectDrive->addItem(QString((char)i) + ":");
    }*/
    connect(ui->redirectDrivesButton, SIGNAL(clicked()), this, SLOT(showRedirectFileDialog()));
}

void EditServer::showRedirectFileDialog()
{
    DiskRedirection * diskRedirection = new DiskRedirection( redirectedDisks );
    if ( diskRedirection->exec() == QDialog::Accepted )
    {
        redirectedDisks = diskRedirection->redirectedDisks();
    }
    delete diskRedirection;
}

void EditServer::loadSettings()
{
    ui->connName->setText( name );
    ui->server->setText( settings->getServer( name ));
    ui->login->setText( settings->getLogin( name ));
    ui->connType->setCurrentIndex( ui->connType->findText( settings->getType( name ), Qt::MatchExactly) );
    ui->domain->setText( settings->getDomain( name ));
    ui->connPort->setValue( settings->getPort( name ));
    QString sSize = settings->getScreenSize( name ).toLower().simplified();
    QString sizeString;
    if (sSize == "fullscreen")
    {
        sizeString = tr("Full Screen");
    } else if ( sSize == "maximized" ) {
        sizeString = tr("Maximized window");
    } else {
        sizeString = sSize;
    }
    ui->screenSize->setCurrentIndex( ui->screenSize->findText( sizeString , Qt::MatchExactly) );
    ui->colorDepth->setCurrentIndex( ui->colorDepth->findText( QString::number(settings->getColorDepth( name )), Qt::MatchExactly) );
    //ui->redirectDrive->setCurrentIndex( ui->redirectDrive->findText( settings->getDriveRedirect( name )) );
    //ui->redirectDriveFolder->setText( settings->getDriveRedirectFolder( name ));
    redirectedDisks = settings->getDriveRedirectFolders( name );
    ui->smartCard->setChecked( settings->getSmartCardRedirect( name ));
    ui->redirectHome->setChecked( settings->getHomeRedirect( name ));
    ui->redirectRemovable->setChecked( settings->getRemovableRedirect( name ));
    ui->redirectPrinters->setChecked( settings->getPrintersRedirect( name ));
    ui->redirectSound->setChecked( settings->getSoundRedirect( name ));
	ui->redirectMicrophone->setChecked( settings->getMicrophoneRedirect( name ));
    ui->wallpaper->setChecked(settings->getWallpaper( name ));
    ui->effects->setChecked(settings->getEffects( name ));
	//ui->rfxMode->setCurrentIndex( ui->rfxMode->findText( settings->getRfxMode(name) ) );
	ui->multimonSupport->setChecked(settings->getMultimonSupport( name ));
    ui->extraArgs->setText( settings->getExtraArgs( name ).join(",") );
}

void EditServer::saveSettings()
{
    settings->addServer( name );
    settings->setServer( name, ui->server->text());
    settings->setLogin( name, ui->login->text());
    settings->setType( name, ui->connType->currentText() );
    settings->setDomain( name, ui->domain->text() );
    settings->setPort( name, ui->connPort->value() );
    if (ui->screenSize->currentText() == tr("Full Screen"))
    {
        settings->setScreenSize( name, "fullscreen" );
    } else if (ui->screenSize->currentText() == tr("Maximized window")) {
        settings->setScreenSize( name, "maximized" );
    } else {
        settings->setScreenSize( name, ui->screenSize->currentText());
    }
    settings->setColorDepth( name, ui->colorDepth->currentText().toInt());
    //settings->setDriveRedirect( name, ui->redirectDrive->currentText());
    //settings->setDriveRedirectFolder( name, ui->redirectDriveFolder->text());
    settings->setDriveRedirectFolders(name, redirectedDisks);
    settings->setSmartCardRedirect( name, ui->smartCard->isChecked());
    settings->setHomeRedirect( name, ui->redirectHome->isChecked());
    settings->setRemovableRedirect( name, ui->redirectRemovable->isChecked());
    settings->setPrintersRedirect( name, ui->redirectPrinters->isChecked());
    settings->setSoundRedirect( name, ui->redirectSound->isChecked());
    settings->setMicrophoneRedirect( name, ui->redirectMicrophone->isChecked());
    settings->setWallpaper( name, ui->wallpaper->isChecked());
    settings->setEffects( name, ui->effects->isChecked());
	//settings->setRfxMode( name, ui->rfxMode->currentText() );
	settings->setMultimonSupport( name, ui->multimonSupport->isChecked());
    settings->setExtraArgs( name, ui->extraArgs->text().split(",") );

    if ( name != ui->connName->text() )
    {
        settings->rename( name, ui->connName->text() );
    }

    settings->sync();
}

EditServer::~EditServer()
{
    delete ui;
}

void EditServer::on_advanced_clicked(bool checked)
{
    ui->advancedWidget->setVisible(checked && FREE_VERSION == 0);
}

void EditServer::accept()
{
    if (ui->connName->text().isEmpty())
    {
        QMessageBox::critical( this, tr("Invalid connection name"), tr("The field 'Connection name' must not be empty"));
    } else {
        bool changedName = ( (! isNew) && (name != ui->connName->text()) );
        if ( isNew || changedName )
        {

            if ( settings->serverList().contains(ui->connName->text()) || settings->defaultServersList().contains(ui->connName->text()) )
            {
                QMessageBox::critical( this, tr("Invalid connection name"), tr("The selected connection name currently exists. Please, select a new one"));
            } else {
                name = ui->connName->text();
                saveSettings();
                QDialog::accept();
            }
        } else {
            saveSettings();
            QDialog::accept();
        }
    }
}

void EditServer::on_connType_currentIndexChanged(const QString &arg1)
{
    bool isLibrework = (arg1 == "Librework");
    if ( ! isLibrework && ui->connPort->value() == LIBREWORK_DEFAULT_PORT)
    {
        ui->connPort->setValue(RDP_DEFAULT_PORT);
    }
    if ( isLibrework && ui->connPort->value() == RDP_DEFAULT_PORT)
    {
        ui->connPort->setValue(LIBREWORK_DEFAULT_PORT);
    }
    ui->redirectPrinters->setVisible(! isLibrework);
    ui->redirectPrintersLabel->setVisible(! isLibrework);
    //ui->redirectDrive->setVisible(isLibrework);
    //ui->redirectDriveButton->setVisible(isLibrework);
    //ui->redirectDriveFolder->setVisible(isLibrework);
    //ui->redirectDriveLabel->setVisible(isLibrework);
}
