#ifndef LOGINSCREEN_H
#define LOGINSCREEN_H

#include <QWidget>
#include <QProcess>
#include <QDateTime>
#include <QPushButton>
#include <QVBoxLayout>
#include <QDialog>
#include <QThread>
#include <QApplication>
#include <QGuiApplication>
#include <QPoint>
#include <QSize>
#include <QDebug>
#include <QSettings>
#include <QFile>

#include "clientsettings.h"
#include "clientsession.h"
#include "clientappbutton.h"

namespace Ui {
class LoginScreen;
class Widget;
}

class LoginScreen : public QWidget
{
    Q_OBJECT

public:
	explicit LoginScreen(bool noDesktop, QWidget *parent = 0);
	~LoginScreen();

private slots:
	void on_toolButton_clicked();
	void on_loginButton_clicked();
	void on_passwordLineEdit_returnPressed();
	void on_loginLineEdit_returnPressed();
	void on_serverComboBox_currentIndexChanged(const QString &selected);
	void on_powerOffButton_clicked();
	void serversChanged();
	void sessionStarted();
	void sessionFinished();

private:
	void forceTranslations();
	QStringList readFile(QString fileName);

	Ui::LoginScreen *ui;

	QString tempFile;
	QDateTime processStart;
	ClientSettings * settings;
	ClientSession * session;
	QProcess * proxyProcess;
	QString hostName;
	QString server;
	int connPort;
};

#endif // LOGINSCREEN_H
