#!/bin/bash

QTDIR=/Users/pechanove/Qt/5.7/clang_64
APPBUNDLE=Librework-Client.app
#FREERDP=/Users/pechanove/FreeRDP.git/trunk/client/Mac/cli/MacFreeRDP.app
FREERDP=macdeploy/MacFreeRDP.app

#NONE="\033[0m"
#EMK="\033[1;30m"
NONE=`tput sgr0`
EMK=`tput bold`

write()
{
	echo "${EMK}$1${NONE}"
}

cd ..

VERSION=`cat constants.h | grep "#define VERSION " | awk -F '[[:space:]]' '{print $3}'`

VERSIONTYPE=(Free Premium Business)

for VTYPE in 2
do
	write "Cleaning up..."
	make distclean
	rm -f $APPBUNDLE.dmg
	write "done."

	write "Chaging version type..."
	sed -i -e "s/#define VERSION_TYPE [0-9]/#define VERSION_TYPE $VTYPE/g" constants.h
	write "done."

	write "Compiling..."
	$QTDIR/bin/qmake
	make
	write "done."

	write "Copying MacFreeRDP to bundle..."
	mkdir -p $APPBUNDLE/Contents/Resources/Translations
	cp -a ${FREERDP} $APPBUNDLE/Contents/Resources/
	write "done."

	write "Copying translations to bundle..."
	cp *.qm $APPBUNDLE/Contents/Resources/Translations
	write "done."

	write "Deploying..."
	$QTDIR/bin/macdeployqt $APPBUNDLE
	write "done."

	#write "Fixing qt deployment for Yosemite..."
	#python macdeploy/fix-yosemite.py $QTDIR $APPBUNDLE
	#write "done."

	write "Signing bundle..."
	#IDENTITY=`certtool y | grep "Mac App Distribution:" | awk -F ': ' '{print $3}'`
	#codesign -f -dvvv --prefix=com.librework. --deep Librework-Client.app -s "Mac App Distribution: ${IDENTITY}"
	IDENTITY=`certtool y | grep "Developer ID Application:" | awk -F ': ' '{print $3}'`
	codesign -f -dvvv --prefix=com.librework. --deep Librework-Client.app -s "Developer ID Application: ${IDENTITY}"
	write "done."

	write "Generating dmg..."
	hdiutil create -volname Librework-Client -srcfolder $APPBUNDLE -ov -format UDZO Librework-Client-${VERSIONTYPE[$VTYPE]}-v${VERSION}.dmg
	write "done."
done
